(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3045,         94]*)
(*NotebookOutlinePosition[      3888,        121]*)
(*  CellTagsIndexPosition[      3844,        117]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 1.6  .3 . \[IndentingNewLine]using\ 3 - 
        point\ trapezoidal\ rule, \ both\ x0\ and\ s0\ same, \ say\ x0 = 0, \ 
      s0 = 0, \[IndentingNewLine]and\ \ \[Mu] = \(-1\)\ *) \
\[IndentingNewLine]\(k[x_, \ s_] := \ 
        Sqrt[x\ s];\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\n", 
    \(matk = 
      Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 
          3}]\), "\[IndentingNewLine]", 
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(b = \ \ \(\(IdentityMatrix[
          3]\)\(+\)\(a\)\(\[IndentingNewLine]\)\)\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 1\/2, 1\/\@2}, {0, 1\/\@2, 1}}\)], "Output"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 5\/4, 1\/\(4\ \@2\)}, {0, 1\/\(2\ \@2\), 
        5\/4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g = {0, \ \ Sqrt[1/2], \ \ Sqrt[1]} // N\)], "Input"],

Cell[BoxData[
    \({0.`, 0.7071067811865475`, 1.`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[b, g] // N\)], "Input"],

Cell[BoxData[
    \({0.`, 0.4714045207910316`, 0.6666666666666666`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{Automatic, 70}, {Automatic, 9}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 744, 15, 203, "Input"],
Cell[2486, 68, 80, 1, 46, "Output"],
Cell[2569, 71, 106, 2, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2712, 78, 73, 1, 27, "Input"],
Cell[2788, 81, 65, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2890, 87, 55, 1, 27, "Input"],
Cell[2948, 90, 81, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

